<?php
/**
 * @package         Modals
 * @version         8.2.2
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2016 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

require_once JPATH_LIBRARIES . '/regularlabs/helpers/functions.php';
require_once JPATH_LIBRARIES . '/regularlabs/helpers/tags.php';
require_once JPATH_LIBRARIES . '/regularlabs/helpers/text.php';
require_once JPATH_LIBRARIES . '/regularlabs/helpers/protect.php';

RLFunctions::loadLanguage('plg_system_modals');

/**
 * Plugin that replaces stuff
 */
class PlgSystemModalsHelper
{
	var $params  = null;
	var $helpers = array();

	public function __construct(&$params)
	{
		$this->params = $params;

		$this->params->class = 'modal_link';
		// array_filter will remove any empty values
		$this->params->classnames = $this->params->autoconvert_classnames ? RLText::createArray(str_replace(' ', ',', trim($this->params->classnames))) : array();

		$this->params->tag = preg_replace('#[^a-z0-9-_]#si', '', $this->params->tag);

		$this->params->paramNamesCamelcase = array(
			'innerWidth', 'innerHeight', 'initialWidth', 'initialHeight', 'maxWidth', 'maxHeight', 'className',
		);
		$this->params->paramNamesLowercase = array_map('strtolower', $this->params->paramNamesCamelcase);
		$this->params->paramNamesBooleans  = array(
			'scalephotos', 'scrolling', 'inline', 'iframe', 'fastiframe',
			'photo', 'preloading', 'retinaimage', 'open', 'returnfocus', 'trapfocus', 'reposition',
			'loop', 'slideshow', 'slideshowauto', 'overlayclose', 'closebutton', 'esckey', 'arrowkey', 'fixed',
		);

		if (JFactory::getApplication()->input->getInt('ml', 0) && !JFactory::getApplication()->input->getInt('fullpage', 0))
		{
			JFactory::getApplication()->input->set('tmpl', JFactory::getApplication()->input->getWord('tmpl', $this->params->tmpl));
		}

		require_once __DIR__ . '/helpers/helpers.php';
		$this->helpers = PlgSystemModalsHelpers::getInstance($params);
	}

	public function onContentPrepare(&$article, $context, $params)
	{
		$area    = isset($article->created_by) ? 'articles' : 'other';
		$context = (($params instanceof JRegistry) && $params->get('rl_search')) ? 'com_search.' . $params->get('readmore_limit') : $context;

		RLHelper::processArticle($article, $context, $this, 'replace', array($area, $context));
	}

	public function onAfterDispatch()
	{
		// only in html
		if (JFactory::getDocument()->getType() !== 'html'
			&& !RLFunctions::isFeed()
		)
		{
			return;
		}

		// do not load scripts/styles on feed or print page
		if (!RLFunctions::isFeed()
			&& !JFactory::getApplication()->input->getInt('print', 0)
		)
		{
			$this->helpers->get('scripts')->loadScriptsStyles();
		}

		if (!$buffer = RLFunctions::getComponentBuffer())
		{
			return;
		}

		$this->replace($buffer, 'component');

		JFactory::getDocument()->setBuffer($buffer, 'component');
	}

	public function onAfterRender()
	{
		// only in html and feeds
		if (JFactory::getDocument()->getType() !== 'html' && !RLFunctions::isFeed())
		{
			return;
		}

		$html = JFactory::getApplication()->getBody();
		if ($html == '')
		{
			return;
		}

		// only do stuff in body
		list($pre, $body, $post) = RLText::getBody($html);
		$this->replace($body, 'body');

		if (strpos($body, $this->params->class) === false)
		{
			// remove style and script if no items are found
			$pre = preg_replace('#\s*<' . 'link [^>]*href="[^"]*/(modals/css|css/modals)/[^"]*\.css[^"]*"[^>]*( /)?>#s', '', $pre);
			$pre = preg_replace('#\s*<' . 'script [^>]*src="[^"]*/(modals/js|js/modals)/[^"]*\.js[^"]*"[^>]*></script>#s', '', $pre);
			$pre = preg_replace('#((?:;\s*)?)(;?)/\* START: Modals .*?/\* END: Modals [a-z]* \*/\s*#s', '\1', $pre);
		}

		$this->helpers->get('replace')->cleanLeftoverJunk($pre);
		$this->helpers->get('replace')->cleanLeftoverJunk($post);

		$html = $pre . $body . $post;

		JFactory::getApplication()->setBody($html);
	}

	public function replace(&$string, $area = 'article', $context = '')
	{
		$this->helpers->get('replace')->replace($string, $area, $context);
	}
}
