<?php

/**
 * @package		K2
 * @author		GavickPro http://gavick.com
 */

// no direct access
defined('_JEXEC') or die;

// Template override
jimport('joomla.filesystem.file');
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
$templateParams = JFactory::getApplication()->getTemplate(true)->params;
$override = JPATH_SITE . DS . 'templates' . DS . 'gk_overrides' . DS . $templateParams->get('custom_override', '-1') . DS . 'html' . DS;
$override .=  'com_k2' . DS . 'templates' . DS . 'default' . DS . 'category.php';

if(
	$templateParams->get('custom_override', '-1') !== '-1' && 
	JFile::exists($override) &&
	__FILE__ !== $override
) :
	include_once($override);
else :


$document = JFactory::getDocument();

?>

<div id="k2Container" class="blog-page <?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">
	
	
	<?php 
	 	$renderer = $document->loadRenderer('modules');
	 	
	 	if($document->countModules('breadcrumb')) {
			echo '<div id="gkBreadcrumb">';
			echo '<div class="gkPage">';
			echo $renderer->render('breadcrumb', array('style' => 'none'), null); 
			echo '</div>';
			echo '</div>';
		}
	?>
	
	<div class="gkPage">
		<div id="gk-content-wrapper">
			<?php 
				if($document->countModules('mainbody_top')) {
					echo '<section id="gkMainbodyTop">';
					echo '<div>';
					echo $renderer->render('mainbody_top', array('style' => 'gk_style'), null); 
					echo '</div>';
					echo '</section>';
				} 
			?>
			
			<?php 
				$items = array();
				
				if(isset($this->leading)) $items = array_merge($items, $this->leading);	
				if(isset($this->primary)) $items = array_merge($items, $this->primary);			
				if(isset($this->secondary)) $items = array_merge($items, $this->secondary);	
			
				if(count($items)): 
			?>
		    <div class="item-list">
		    	<?php foreach($items as $item): ?>
					<?php
						$this->item = $item;
						echo $this->loadTemplate('item');
					?>
		         <?php endforeach; ?>
		    </div>
		    
		    <?php if(count($this->pagination->getPagesLinks())): ?>
			    <?php if($this->params->get('catPagination')): ?>
			    	<?php echo $this->pagination->getPagesLinks(); ?>
			    <?php endif; ?>
		    <?php endif; ?>
		    
		    <?php if($this->params->get('catFeedIcon')): ?>
		    <div class="k2FeedIcon">
		    	<a href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>">
		    		<span><?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?></span>
		    	</a>
		    	<div class="clr"></div>
		    </div>
		    <?php endif; ?>
		    
		    <?php endif; ?>
		    
		    <?php 
	    		if($document->countModules('mainbody_bottom')) {
	    			echo '<section id="gkMainbodyBottom">';
	    			echo '<div>';
	    			echo $renderer->render('mainbody_bottom', array('style' => 'gk_style'), null); 
	    			echo '</div>';
	    			echo '</section>';
	    		} 
	    	?>
		</div>
		
		<?php 
		 	$renderer = $document->loadRenderer('modules');
		 	
		 	if($document->countModules('sidebar')) {
		 		echo '<aside id="gkSidebar">';
		 		echo '<div>';
		 		echo $renderer->render('sidebar', array('style' => 'gk_style'), null); 
		 		echo '</div>';
		 		echo '</aside>';
		 	}
		?>
    </div>
</div>
<?php endif; ?>